<?php
session_start();
require_once '../config/db.php';
require_once '../helpers/helpers.php';
require_once '../auth/auth.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// Check if user has permission to edit invoices
if (!hasPermission('edit_invoice')) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Permission denied']);
    exit;
}

try {
    $invoice_id = $_GET['id'] ?? null;
    
    if (!$invoice_id) {
        throw new Exception('Invoice ID is required');
    }
    
    // Get invoice details
    $stmt = $pdo->prepare("
        SELECT 
            i.*,
            c.name as customer_name,
            c.email as customer_email,
            c.phone as customer_phone,
            c.address as customer_address,
            u.username as created_by_name
        FROM invoices i
        LEFT JOIN customers c ON i.customer_id = c.id
        LEFT JOIN users u ON i.created_by = u.id
        WHERE i.id = ?
    ");
    $stmt->execute([$invoice_id]);
    $invoice = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$invoice) {
        throw new Exception('Invoice not found');
    }
    
    // Check if invoice is paid (prevent editing paid invoices)
    if ($invoice['status'] === 'paid') {
        throw new Exception('Cannot edit paid invoices');
    }
    
    // Get invoice items
    $stmt = $pdo->prepare("
        SELECT 
            ii.*,
            p.name as product_name,
            p.price as product_price
        FROM invoice_items ii
        LEFT JOIN products p ON ii.product_id = p.id
        WHERE ii.invoice_id = ?
        ORDER BY ii.id
    ");
    $stmt->execute([$invoice_id]);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get all customers for dropdown
    $stmt = $pdo->prepare("SELECT id, name, email, phone FROM customers ORDER BY name");
    $stmt->execute();
    $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get all products for dropdown
    $stmt = $pdo->prepare("SELECT id, name, price FROM products ORDER BY name");
    $stmt->execute();
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'invoice' => $invoice,
        'items' => $items,
        'customers' => $customers,
        'products' => $products
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?> 